%% Cell segmentation from superSegger
% segment cells using SuperSegger (Stylianidou et al. 2016)
% this gives folder structure that is used in this script

% estimate alignment from spots
estimateAlignment

% collect data from population exp
generateSpotsPop(2, out)

% load spotsPop.mat 

%% Average MukB pixel intensity with distance to ori/ter
% assumes ori - fluo1, ter - fluo2, MukB - fluo3

% for plotting
maxDist = 15;       % maximum distances
binning = 0.5;      % bin size
pixel = 0.11;       % pixel size in um

% select *_pop_spots.mat file(s)
[filename,pathname] = uigetfile('*.mat', 'Select','MultiSelect', 'on');
if iscell(filename)
    no_files = length(filename);
    filename_cell = filename;
else
    no_files = 1;
    filename_cell{1} = filename;
end
   
mean_Y_ori_all = NaN(length(((binning/2):binning:maxDist)),no_files);
mean_Y_ter_all = NaN(length(((binning/2):binning:maxDist)),no_files);
no_cells_all = [];
for kk = 1:no_files
    % load files
    load([pathname filename_cell{kk}]);

    ori_dists = cell(1,length(spots));      % all dists
    ori_int = cell(1,length(spots));        % pixel intensity bg corrected
    ori_int_corr = cell(1,length(spots));   % intensity subtracted average cell int
    ori_int_norm = cell(1,length(spots));   % intensity subtracted average cell int and normalized by max int
    ter_dists = cell(1,length(spots));      % all dists
    ter_int = cell(1,length(spots));        % pixel intensity bg corrected
    ter_int_corr = cell(1,length(spots));   % intensity subtracted average cell int
    ter_int_norm = cell(1,length(spots));   % intensity subtracted average cell int and normalized by max int
    aveg_int = cell(1,length(spots));       % average cell intensity
    sum_int = cell(1,length(spots));        % total cell intensity

    for ii = 1:length(spots)
        X = spots(ii).X;
        Y = spots(ii).Y;

        % average and summed ints
        Ints = spots(ii).fluo3Raw(spots(ii).fluo3Raw > 0);
        Ints = double(Ints-spots(1).cellFluo3Bg);   % remove background
        aveg_int{ii} = mean(Ints);
        sum_int{ii} = sum(Ints);

        % dist to ori
        if ~isempty(spots(ii).fluo1.coord) && ~isempty(spots(ii).fluo2.coord)
            % subtract offset and alignment as raw image has not been
            % aligned (use fluo3 value)
            xcoord = spots(ii).fluo1.coord(1:2:end)-spots(ii).offset(1)-align{3}(4);
            ycoord = spots(ii).fluo1.coord(2:2:end)-spots(ii).offset(2)-align{3}(3);
            X1 = [xcoord' ycoord'];

            % coords
            [yMask, xMask] = find(spots(ii).fluo3Raw > 0);
            X2 = [xMask yMask];

            % distance to all px and norm int
            X = [X1; X2];
            d = pdist(X,'euclidean');
            Z = squareform(d);

            % choose distance to closest ori
            dists_all = [];
            int_all = [];
            int_corr_all = [];
            int_norm_all = [];
            for jj = (length(xcoord)+1):size(X,1)
                dists = min(Z(jj,1:length(xcoord)));
                dists_all = [dists_all dists];
                int_all = [int_all Ints(jj-length(xcoord))];
                int_corr_all = [int_corr_all Ints(jj-length(xcoord))-median(Ints)];
                int_norm_all = [int_norm_all (Ints(jj-length(xcoord))-median(Ints))./max(Ints)]; %norm_value
            end
            ori_dists{ii} = dists_all;
            ori_int{ii} = int_all;
            ori_int_corr{ii} = int_corr_all;
            ori_int_norm{ii} = int_norm_all;
        end

        % dist to ter
        if ~isempty(spots(ii).fluo2.coord) && ~isempty(spots(ii).fluo1.coord)
            % subtract offset and alignment as raw image has not been
            % aligned (use fluo3 value)
            xcoord = spots(ii).fluo2.coord(1:2:end)-spots(ii).offset(1)-align{3}(4);
            ycoord = spots(ii).fluo2.coord(2:2:end)-spots(ii).offset(2)-align{3}(3);
            X1 = [xcoord' ycoord'];

            % coords
            [yMask, xMask] = find(spots(ii).fluo3Raw > 0);
            X2 = [xMask yMask];

            % distance to all px and norm int
            X = [X1; X2];
            d = pdist(X,'euclidean');
            Z = squareform(d);

            % choose distance to closest ter
            dists_all = [];
            int_all = [];
            int_corr_all = [];
            int_norm_all = [];
            for jj = (length(xcoord)+1):size(X,1)
                dists = min(Z(jj,1:length(xcoord)));
                dists_all = [dists_all dists];
                int_all = [int_all Ints(jj-length(xcoord))];
                int_corr_all = [int_corr_all Ints(jj-length(xcoord))-mean(Ints)];
                int_norm_all = [int_norm_all (Ints(jj-length(xcoord))-mean(Ints))./max(Ints)];
            end
            ter_dists{ii} = dists_all;
            ter_int{ii} = int_all;
            ter_int_corr{ii} = int_corr_all;
            ter_int_norm{ii} = int_norm_all;
        end
    end
    % number of cells
    no_cells = length(ori_dists)-sum(cellfun(@isempty, ori_dists));
    no_cells_all = [no_cells_all no_cells];

    % plotting

    % mean pixel intensity subtracted and normalized by foci pixel intensities
    ori_dists2 = [ori_dists{:}];
    ori_int_norm2 = [ori_int_norm{:}];
    ter_dists2 = [ter_dists{:}];
    ter_int_norm2 = [ter_int_norm{:}];

    % ori
%     figure; hold on;
    [~,~,idx] = histcounts(ori_dists2,0:binning:maxDist);
    ori_dists2 = ori_dists2(idx ~= 0);
    ori_int_norm2 = ori_int_norm2(idx ~= 0);
    idx = idx(idx ~= 0);
    mean_X_ori = accumarray(idx(:),ori_dists2',[],@mean);
    mean_Y_ori = accumarray(idx(:),ori_int_norm2',[],@mean);
%     plot(mean_X_ori.*pixel, mean_Y_ori,'r','LineWidth',2)
    % ter
    [~,~,idx] = histcounts(ter_dists2,0:binning:maxDist);
    ter_dists2 = ter_dists2(idx ~= 0);
    ter_int_norm2 = ter_int_norm2(idx ~= 0);
    idx = idx(idx ~= 0);
    mean_X_ter = accumarray(idx(:),ter_dists2',[],@mean);
    mean_Y_ter = accumarray(idx(:),ter_int_norm2',[],@mean);
%     plot(mean_X_ter.*pixel, mean_Y_ter,'b','LineWidth',2)
    

    mean_Y_ori_all(:,kk) = mean_Y_ori;         
    mean_Y_ter_all(:,kk) = mean_Y_ter; 

end

% plot mean with STD
mean_Y_ori_all2 = mean(mean_Y_ori_all,2);
STD_Y_ori_all2 = std(mean_Y_ori_all,0,2);
mean_Y_ter_all2 = mean(mean_Y_ter_all,2);
STD_Y_ter_all2 = std(mean_Y_ter_all,0,2);

figure; hold on;
errorbar(((binning/2):binning:maxDist).*pixel, mean_Y_ori_all2,STD_Y_ori_all2,'r','LineWidth',1)
errorbar(((binning/2):binning:maxDist).*pixel, mean_Y_ter_all2,STD_Y_ter_all2,'b','LineWidth',1)
xlabel('Distance from MukE pixel to ori1')
ylabel('Normalized intensity')

sum(no_cells_all)

%% Max and average MukB intensity
% extract max pixel intensity

max_ints = [];
conc = [];
for ii = 1:length(spots)
    ints = double(spots(ii).fluo3Raw(:))-spots(ii).cellFluo3Bg;
    ints = ints(ints > 0);
    
    % total concentration
    conc = [conc sum(ints)./length(ints)];
    max_ints = [max_ints max(ints)];
end

mean(max_ints)
mean(max_ints)-mean(conc)
mean(conc)
